<?php

namespace ILC\PermissionCenter;

use Illuminate\Support\Facades\Gate;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use ILC\PermissionCenter\Commands\PermissionCenterCommand;

class PermissionCenterServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('permissioncenter')
            ->hasMigration('modify_permissions_tables')
            ->hasCommand(PermissionCenterCommand::class);
    }

    /**
     * Registra las rutas de la aplicación.
     *
     * Este método carga las rutas desde el archivo api.php que se encuentra
     * en el directorio de rutas del paquete.
     */
    protected function registerRoutes(): void
    {
        $this->loadRoutesFrom(__DIR__.'/routes/api.php');
    }

    public function boot()
    {
        parent::boot();

        $this->registerRoutes();

        Gate::before(function ($user, $ability) {
            return $user->hasRole('Super administrador') ? true : null;
        });
    }
}
