<?php

namespace ILC\PermissionCenter\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use Spatie\Permission\Models\Role as Rol;

class RolController implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:ver-roles', only:['index', 'show']),
            new Middleware('can:crear-roles', only:['store']),
            new Middleware('can:editar-roles', only:['update']),
            new Middleware('can:borrar-roles', only:['destroy']),
        ];
    }
	public function index(Request $request)
	{
        $data = Rol::with('permissions')->when(!empty($request->filtro), fn($query) =>
            $query->where('name', 'like', "%$request->filtro%")
        );

        return $data->paginate($request->get('perPage', 10));
	}

	public function store(Request $request)
	{
        $request->validate([
            'name' => ['required', 'regex:/^[a-zA-Z0-9\s\-]+$/u'],
            'module' => ['required'],
            'description' => ['required']
        ]);
        $data = $request->only(['name', 'module', 'description']);
        $data['guard_name'] = 'web';
		return Rol::create($data);
	}

	public function update(Request $request, Rol $rol)
	{
        $request->validate([
            'name' => ['required', 'regex:/^[a-zA-Z0-9\s\-]+$/u'],
            'module' => ['required'],
            'description' => ['required']
        ]);

        $rol->update($request->only(['name', 'module', 'description']));

        return new JsonResponse(['mensaje'=> 'Actualizado correctamente']);
	}

	public function destroy(Rol $rol)
	{
		$rol->delete();
        return new JsonResponse(['mensaje'=> 'Eliminado correctamente']);
	}

	public function sincronizarPermisos(Request $request, Rol $rol)
	{
		$request->validate([
			'permisos' => 'required|array',
			'permisos.*' => 'nullable|exists:permissions,id',
		]);


		$rol->syncPermissions([$request->permisos]);

        return new JsonResponse(['mensaje'=> 'Permisos sincronizados correctamente']);
	}
}
