<?php

namespace ILC\PermissionCenter\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use Spatie\Permission\Models\Permission as Permiso;

class PermisoController implements HasMiddleware
{

    public static function middleware(): array
    {
        return [
            new Middleware('can:ver-permisos', only:['index', 'show']),
            new Middleware('can:crear-permisos', only:['store']),
            new Middleware('can:editar-permisos', only:['update']),
            new Middleware('can:borrar-permisos', only:['destroy']),
        ];
    }

    public function index(Request $request)
	{
        $data = Permiso::when(!empty($request->filtro), fn($query) =>
            $query->where('name', 'like', "%$request->filtro%")
        );
		return $data->paginate($request->get('perPage', 10));
	}

	public function store(Request $request)
	{
        $request->validate([
            'name' => ['required', 'regex:/^[a-zA-Z0-9\s\-]+$/u'],
            'module' => ['required'],
            'description' => ['required']
        ]);
        $data = $request->only(['name', 'module', 'description']);
        $data['guard_name'] = 'web';
		return Permiso::create(
            $data
        );
	}

	public function update(Request $request, Permiso $permiso)
	{
        $request->validate([
            'name' => ['required', 'regex:/^[a-zA-Z0-9\s\-]+$/u'],
            'module' => ['required'],
            'description' => ['required']
        ]);

		$permiso->update($request->only(['name', 'module', 'description']));
        return new JsonResponse(['mensaje'=> 'Actualizado correctamente']);
	}

	public function destroy(Permiso $permiso)
	{
		$permiso->delete();
        return new JsonResponse(['mensaje'=> 'Eliminado correctamente']);
	}
}
