<?php

namespace ILC\PermissionCenter\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermisosSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Permission::firstOrCreate([
            'name' => 'ver-permiso',
            'description' => 'permite al usuario ver los permisos',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'crear-permiso',
            'description' => 'permite al usuario crear permisos',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'editar-permiso',
            'description' => 'permite al usuario editar los permisos',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'borrar-permiso',
            'description' => 'permite al usuario borrar permisos',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);

        Permission::firstOrCreate([
            'name' => 'ver-roles',
            'description' => 'permite al usuario ver los roles',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'crear-roles',
            'description' => 'permite al usuario crear roles',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'editar-roles',
            'description' => 'permite al usuario editar los roles',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'borrar-roles',
            'description' => 'permite al usuario borrar roles',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);

        Permission::firstOrCreate([
            'name' => 'asignar-permisos',
            'description' => 'permite al usuario definir los permisos dentro de un rol o un usuario',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'retirar-permisos',
            'description' => 'permite al usuario quitar permisos previamente asignados a un rol o un usuario',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'asignar-roles',
            'description' => 'permite al usuario asignar roles a usuarios',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
        Permission::firstOrCreate([
            'name' => 'retirar-roles',
            'description' => 'permite al usuario quitar roles previamente asignados a usuarios',
            'module' => 'permisos',
            'guard_name' => 'web'
        ]);
    }
}
