<?php

namespace ILC\PermissionCenter\Rules;

use Illuminate\Contracts\Validation\Rule;
use Spatie\Permission\Models\Role as Rol;
use ILC\PermissionCenter\Services\UserLevel;

class CanAssignRolesRule implements Rule
{
    /**
     * @var string
     */
    protected $errorMessage = '';

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value The array of role IDs.
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!config('permission-center.niveles', true)) {
            return true;
        }

        $userLevel = UserLevel::getFor(auth()->user());
        $roles = is_numeric($value[0]) ? Rol::findMany($value) : Rol::whereIn('name', $value)->get();

        foreach ($roles as $rol) {

            if ($userLevel > $rol->level) {
                $this->errorMessage = "No tienes la jerarquía suficiente para asignar el rol \"{$rol->name}\".";
                return false;
            }
        }

        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->errorMessage;
    }
}
