<?php

namespace ILC\PermissionCenter\Rules;

use Illuminate\Contracts\Validation\Rule;
use Spatie\Permission\Models\Permission as Permiso;
use ILC\PermissionCenter\Services\UserLevel;

class CanAssignPermissionsRule implements Rule
{
    /**
     * @var string
     */
    protected $errorMessage = '';

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value The array of permission IDs.
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!config('permission-center.niveles', true)) {
            return true;
        }

        $userLevel = UserLevel::getFor(auth()->user());
        $permissions = is_numeric($value[0]) ? Permiso::findMany($value) : Permiso::whereIn('name', $value)->get();

        foreach ($permissions as $permission) {
            if ($userLevel > $permission->level) {
                $this->errorMessage = "No tienes la jerarquía suficiente para asignar el permiso \"{$permission->name}\".";
                return false;
            }
        }

        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->errorMessage;
    }
}
