<?php

namespace ILC\PermissionCenter\Queries;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role as Rol;
use Illuminate\Database\Eloquent\Builder;

class RolIndexQuery
{
    /**
     * @param Request $request
     * @return Builder
     */
    public function __invoke(Request $request): Builder
    {
        return Rol::with('permissions')->when(!empty($request->filtro), fn($query) =>
            $query->where('name', 'ilike', "%$request->filtro%")
                ->orWhere('module', 'ilike', "%$request->filtro%")
                ->orWhere('description', 'ilike', "%$request->filtro%")
        );
    }
}
