<?php

namespace ILC\PermissionCenter\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermisosSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [
                'name' => 'listar.permisos',
                'description' => 'permite al usuario ver los permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'crear.permisos',
                'description' => 'permite al usuario crear permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'editar.permisos',
                'description' => 'permite al usuario editar los permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'borrar.permisos',
                'description' => 'permite al usuario borrar permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'listar.roles',
                'description' => 'permite al usuario ver los roles',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'crear.roles',
                'description' => 'permite al usuario crear roles',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'editar.roles',
                'description' => 'permite al usuario editar los roles',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'borrar.roles',
                'description' => 'permite al usuario borrar roles',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 1,
            ],
            [
                'name' => 'asignar.permisos',
                'description' => 'permite al usuario definir los permisos dentro de un rol o un usuario',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 2,
            ],
            [
                'name' => 'retirar.permisos',
                'description' => 'permite al usuario quitar permisos previamente asignados a un rol o un usuario',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 2,
            ],
            [
                'name' => 'asignar.roles',
                'description' => 'permite al usuario asignar roles a usuarios',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 2,
            ],
            [
                'name' => 'retirar.roles',
                'description' => 'permite al usuario quitar roles previamente asignados a usuarios',
                'module' => 'permisos',
                'guard_name' => 'web',
                'level' => 2,
            ],
        ];

        foreach ($permissions as $permission) {
            if(!config('permission-center.niveles', true)){
                unset($permission['level']);
            }
            Permission::firstOrCreate(['name' => $permission['name']], $permission);
        }
    }
}
