<?php

use ILC\PermissionCenter\Controllers\PermisoController;
use ILC\PermissionCenter\Controllers\RolController;
use ILC\PermissionCenter\Controllers\UsuarioController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth:sanctum')->group(function () {

    $middlewares = array_merge(['api', 'web'], class_exists(\ILC\AdminUsuarios\AdminUsuariosServiceProvider::class) ? ['ilc.auth'] : []);

    Route::prefix('api/admin')->middleware($middlewares)->group(function () {

        Route::apiresource('permisos',PermisoController::class);

        Route::apiresource('roles',RolController::class)
        ->parameters(['roles' => 'rol']);

        Route::post('roles/{rol}/permisos', [RolController::class, 'sincronizarPermisos']);
        Route::get('usuarios', [UsuarioController::class, 'index']);//->middleware('can:ver-listado-usuarios');
        Route::get('usuarios/{usuario}', [UsuarioController::class, 'show']);
        Route::post('usuarios/{usuario}/permisos', [UsuarioController::class, 'darPermisosUsuario']);
        Route::post('usuarios/{usuario}/roles', [UsuarioController::class, 'darRolesUsuario']);
        Route::delete('usuarios/{usuario}/permisos/{permiso}', [UsuarioController::class, 'quitarPermisoUsuario']);
        Route::delete('usuarios/{usuario}/roles/{rol}', [UsuarioController::class, 'quitarRolUsuario']);
    });

});
