<?php

namespace ILC\PermissionCenter\Services;

use Illuminate\Contracts\Auth\Authenticatable;

class UserLevel
{
    /**
     * @var array
     */
    protected static $cache = [];

    /**
     * Calcula y cachea el nivel de jerarquía para un usuario dado.
     *
     * @param \Illuminate\Contracts\Auth\Authenticatable $user
     * @return int
     */
    public static function getFor(Authenticatable $user): int
    {
        $userId = $user->getAuthIdentifier();

        if (isset(self::$cache[$userId])) {
            return self::$cache[$userId];
        }

        $roleLevels = $user->roles()->pluck('level');

        $allLevels = $roleLevels->filter();

        if ($allLevels->isEmpty()) {
            return self::$cache[$userId] = PHP_INT_MAX;
        }

        return self::$cache[$userId] = $allLevels->min();
    }
}
