<?php

namespace ILC\PermissionCenter\Rules;

use App\Models\User;
use Illuminate\Contracts\Validation\Rule;
use ILC\PermissionCenter\Services\UserLevel;

class UserCanBeModifiedRule implements Rule
{
    /**
     * @var string
     */
    protected $errorMessage = '';

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!config('permission-center.niveles')) {
            return true;
        }

        $targetUser = $this->getTargetUserFromRoute();

        if (!$targetUser) {
            $this->errorMessage = 'No se pudo determinar el usuario de destino desde la ruta.';
            return false;
        }

        $userLevel = UserLevel::getFor(auth()->user());
        $targetUserLevel = UserLevel::getFor($targetUser);

        if ($userLevel > $targetUserLevel) {
            $this->errorMessage = 'No puedes modificar a un usuario con una jerarquía superior a la tuya.';
            return false;
        }

        return true;
    }

   protected function getTargetUserFromRoute()
    {
        $userModelClass = config('auth.providers.users.model');

        foreach (request()->route()->parameters() as $parameter) {
            if ($parameter instanceof $userModelClass) {
                return $parameter;
            }
        }

        return null;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->errorMessage;
    }
}
