<?php

namespace ILC\PermissionCenter\Rules;

use Illuminate\Contracts\Validation\Rule;
use ILC\PermissionCenter\Services\UserLevel;

class LevelRule implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!config('permission-center.niveles')) {
            return true;
        }

        if (!is_numeric($value)) {
            return false;
        }

        $userLevel = UserLevel::getFor(auth()->user());

        // El nivel del usuario debe ser menor o igual (mayor o igual jerarquía) que el nivel que se está asignando.
        return $userLevel <= $value;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'No puedes asignar una jerarquía superior a la tuya.';
    }
}
