<?php

namespace ILC\PermissionCenter\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class PermissionCenterCommand extends Command
{
    public $signature = 'permission-center:install';

    public $description = 'Realiza las acciones necesarias para instalar el paquete de gestión de roles y permisos';

    public function handle(): int
    {
        $this->info('Copiando migraciones');
        Artisan::call('vendor:publish', ['--tag' => 'permissioncenter-migrations']);

        $this->info('Ejecutando migraciones');
        Artisan::call('migrate');
        $this->info(Artisan::output());

        $this->info('Ejecutando seeders');
        Artisan::call('db:seed', ['--class' => '\ILC\PermissionCenter\Database\Seeders\PermisosSeeder']);
        $this->info(Artisan::output());
        Artisan::call('db:seed', ['--class' => '\ILC\PermissionCenter\Database\Seeders\RolesSeeder']);
        $this->info(Artisan::output());

        $this->info('PermissionCenter instalado correctamente');
        return self::SUCCESS;
    }
}
