const notificaciones = ref([])

// Función para mostrar una notificación desde cualquier componente
const mostrarNotificacion = (tipo, mensaje, duracion = 3000) => {
	notificaciones.value.push({
		tipo,
		mensaje,
		visibilidad: true,
		duracion
	})
}

// Función para cerrar una notificación
const cerrarNotificacion = (index) => {
	notificaciones.value.splice(index, 1)
}

// Función para obtener el color según el tipo de notificación
const obtenerColor = (tipo) => {
	switch (tipo) {
		case 'success':
			return 'green'
		case 'error':
			return 'red'
		default:
			return 'blue'
	}
}

export function usarNotificacion() {
	return {
		notificaciones,
		mostrarNotificacion,
		cerrarNotificacion,
		obtenerColor
	}
}
