<?php

namespace ILC\PermissionCenter\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RolesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roles = [
            [
                'name' => 'Super usuario',
                'module' => 'permisos',
                'description' => 'Usuario que tiene acceso técnico a nivel superior',
                'guard_name' => 'web',
            ],
            [
                'name' => 'administrador de permisos',
                'module' => 'permisos',
                'description' => 'se encarga de gestionar permisos y asignarlos a los roles',
                'guard_name' => 'web',
            ],
            [
                'name' => 'administrador de roles',
                'module' => 'permisos',
                'description' => 'se encarga de gestionar roles y asignarlos a los usuarios',
                'guard_name' => 'web',
            ],
            [
                'name' => 'gestor de usuarios',
                'module' => 'permisos',
                'description' => 'Puede manipular permisos, roles y asignaciones',
                'guard_name' => 'web',
            ],
        ];

        foreach ($roles as $role) {
            Role::firstOrCreate(['name' => $role['name']], $role);
        }
    }
}
