<?php

namespace ILC\PermissionCenter\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermisosSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [
                'name' => 'ver-permisos',
                'description' => 'permite al usuario ver los permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'crear-permisos',
                'description' => 'permite al usuario crear permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'editar-permisos',
                'description' => 'permite al usuario editar los permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'borrar-permisos',
                'description' => 'permite al usuario borrar permisos',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'ver-roles',
                'description' => 'permite al usuario ver los roles',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'crear-roles',
                'description' => 'permite al usuario crear roles',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'editar-roles',
                'description' => 'permite al usuario editar los roles',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'borrar-roles',
                'description' => 'permite al usuario borrar roles',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'asignar-permisos',
                'description' => 'permite al usuario definir los permisos dentro de un rol o un usuario',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'retirar-permisos',
                'description' => 'permite al usuario quitar permisos previamente asignados a un rol o un usuario',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'asignar-roles',
                'description' => 'permite al usuario asignar roles a usuarios',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
            [
                'name' => 'retirar-roles',
                'description' => 'permite al usuario quitar roles previamente asignados a usuarios',
                'module' => 'permisos',
                'guard_name' => 'web',
            ],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission['name']], $permission);
        }
    }
}
