<?php

namespace ILC\ConfigCenter\Requests;

use ILC\ConfigCenter\Models\Configuracion;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ActualizarConfiguracionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $tabla = config('configcenter.tabla');

        // Utilizamos el mismo dbconfig para ver si hay una variable que defina el valor maximo de la variable
        $maximo = dbconfig('VALOR_MAXIMO_VARIABLE', config('configcenter.valor_maximo_variable'));

        return [
            'nombre' => ['required', 'max:125'],
            'identificador' => ['required', 'max:125', 'alpha_dash', Rule::unique($tabla, 'identificador')->ignore($this->route('configuracion'))],
            'descripcion' => ['required', 'string'],
            'tipo' => ['required', 'in:texto,textarea,numeric-input,imagen,archivo,rango,select-one,select,selector-color'],
            'opciones' => ['nullable'],
            'valor' => ['required', 'max:'.$maximo],
            'tags' => ['nullable', 'string']
        ];
    }

    /*public function messages()
    {
        return [

        ];
    }*/
}
