<?php

use ILC\ConfigCenter\Models\Configuracion;

if (!function_exists('dbconfig')) {

    /**
     * Recupera el valor de configuración en cache proveniente de base de datos
     *
     * @param string $nombre_configuracion identificador de la configuración
     * @param string $fvalor_por_defecto valor a devolver en caso de no existir dicha configuración en la cache
     *
     * @return mixed valor de la configuración o default
     */
    function dbconfig(string $nombre_configuracion, mixed $valor_por_defecto = null): mixed
    {
        $data = Configuracion::cargarCache();

        if(isset($data[$nombre_configuracion]))
            return $data[$nombre_configuracion];

        return $valor_por_defecto;
    }
}
