<?php

namespace ILC\ConfigCenter\Providers;

use ILC\ConfigCenter\Events\ConfiguracionActualizada;
use ILC\ConfigCenter\Events\ConfiguracionCreada;
use ILC\ConfigCenter\Events\ConfiguracionEliminada;
use ILC\ConfigCenter\Listeners\HandleConfiguracionActualizada;
use ILC\ConfigCenter\Listeners\HandleConfiguracionCreada;
use ILC\ConfigCenter\Listeners\HandleConfiguracionEliminada;
use \Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        ConfiguracionCreada::class => [ HandleConfiguracionCreada::class ],
        ConfiguracionActualizada::class => [ HandleConfiguracionActualizada::class ],
        ConfiguracionEliminada::class => [ HandleConfiguracionEliminada::class ]
    ];

    public function boot()
    {
        parent::boot();
    }
}
