<?php

namespace ILC\ConfigCenter\Controllers;

use ILC\ConfigCenter\Events\ConfiguracionActualizada;
use ILC\ConfigCenter\Events\ConfiguracionCreada;
use ILC\ConfigCenter\Events\ConfiguracionEliminada;
use ILC\ConfigCenter\Models\Configuracion;
use ILC\ConfigCenter\Requests\GuardarConfiguracionRequest;
use ILC\ConfigCenter\Requests\ActualizarConfiguracionRequest;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ConfiguracionController
{
    public function index(Request $request){
        $data = Configuracion::query()
            ->when($request->has('configuracion'), fn($query) => $query->where('nombre', 'like', "%$request->configuracion%") )
            ->when($request->has('descripcion'), fn($query) => $query->where('descripcion', 'like', "%$request->descripcion%") )
            ->when($request->has('actualizacion'), fn($query) => $query->where('updated_at', 'like', "%$request->actualizacion%") )
            ->when($request->has('tags'), fn($query) => $query->where('tags', 'like', "%$request->tags%") );
        return $data->paginate($reuest->itemsPerPage ?? 10);
    }

    public function store(GuardarConfiguracionRequest $request){
        $data = $request->all();
        if ($request->hasFile('valor')) {
            $path = $request->valor->store('configuracion', 'public');
            $data['valor'] = $path;
        }
        $config = Configuracion::create($data);
        ConfiguracionCreada::dispatch($config);
        return new JsonResponse(['message'=>'Configuración almacenada'], 201);
    }

    public function show($configuracion){
        $configuracion = Configuracion::findOrFail($configuracion);
        return new JsonResponse($configuracion);
    }

    public function update(ActualizarConfiguracionRequest $request, $configuracion,){
        $configuracion = Configuracion::findOrFail($configuracion);
        $data = $request->all();
        if ($request->hasFile('valor')) {
            Storage::delete($configuracion->valor);
            $path = $request->valor->store('configuracion', 'public');
            $data['valor'] = $path;
        }
        $configuracion->update($data);
        ConfiguracionActualizada::dispatch($configuracion);
        return new JsonResponse(['message'=>'Configuración actualizada'], 200);
    }

    public function destroy($configuracion){
        $configuracion = Configuracion::findOrFail($configuracion);
        $configuracion->delete();
        ConfiguracionEliminada::dispatch($configuracion);
        return new JsonResponse(['message' => 'Configuiración eliminada'], 200);
    }

    public function changeValue(Request $request, $configuracion,){
        $configuracion = Configuracion::findOrFail($configuracion);
        $maximo = dbconfig('VALOR_MAXIMO_VARIABLE', config('configcenter.valor_maximo_variable'));
        $request->validate([
            'valor' => ['required', 'max:'.$maximo]
        ]);
        $data = $request->valor;
        if ($request->hasFile('valor')) {
            Storage::delete($configuracion->valor);
            $data = $request->valor->store('configuracion','public');
        }
        $configuracion->valor = $data;
        $configuracion->save();
        ConfiguracionActualizada::dispatch($configuracion);
        return new JsonResponse(['message'=>'Configuración actualizada'], 200);
    }

    public function renderFront()
    {
        return view('configcenter::gestionarConfiguraciones');
    }
}
