# Modulo de gestion de variables de configuracion del sistema

[![GitHub Tests Action Status](https://img.shields.io/github/workflow/status/improvinglaborcourts/configcenter/run-tests?label=tests)](https://github.com/improvinglaborcourts/configcenter/actions?query=workflow%3Arun-tests+branch%3Amain)
[![GitHub Code Style Action Status](https://img.shields.io/github/workflow/status/improvinglaborcourts/configcenter/Fix%20PHP%20code%20style%20issues?label=code%20style)](https://github.com/improvinglaborcourts/configcenter/actions?query=workflow%3A"Fix+PHP+code+style+issues"+branch%3Amain)


Este paquete ofrece una interfaz sencilla y facil de usar para gestionar las configuraciones del sistema.

## Instalación

Primero configuramos nuestro composer.json, agregando el siguiente contenido:
```json
{
    "repositories": [
      {
        "type": "vcs",
        "url": "https://github.com/ImprovingLaborCourts/ConfigCenter.git"
      }
    ]
}
```
Una vez hecho eso podemos instalar mediante composer:

```bash
composer require improvinglaborcourts/configcenter --dev
```
Para facilitar el proceso de instalación se creó un comando que:
1. Publica y ejecuta migraciones
2. Publica y ejecuta seeders
3. Limpia y publica/actualiza los assets necesarios para la GUI
```bash
php artisan configcenter:instalar
```
Opcionalmente, aún puedes hacer el proceso de instalación de manera manual
```bash
php artisan vendor:publish --tag="configcenter-migrations"
php artisan migrate
php artisan vendor:publish --tag configcenter-assets
```
Si se desea proteger el acceso con permisos también se debe ejecutar;
```bash
php artisan vendor:publish --tag configcenter-seeders
php artisan db:seed --class=ConfigCenterSeeder
```
## Configuración
Por defecto el sistema usará el nombre **configuraciones** para la tabla en base de datos para modificar este comportamiento puedes publicar y modificar el valor en el archivo de configuración
```bash
php artisan vendor:publish --tag="configcenter-config"
```
El contenido del archivo es similar a este
```php
return [
    'tabla' => env('MODULO_CONFIGURACIONES_TABLA','configuraciones')
    'seguridad_activa' => env('MODULO_CONFIGURACIONES_SEGURIDAD', true)
];
```
Como se puede observar, se obtiene el mismo resultado agregando las variables **MODULO_CONFIGURACIONES_TABLA** y/o **MODULO_CONFIGURACIONES_SEGURIDAD** al archivo .env del proyecto.
## Uso

Para poder usar el proyecto hay que visitar ___/gestionar-configuraciones___ y usar la interfaz gráfica de usuario, si se está usando la seguridad por defecto se requieren de los siguientes permisos:

- ver-listado-configuracion
- crear-configuracion
- editar-configuracion
- borrar-configuracion

El paquete también provee un helper global para recuperar la configuración, en base a su identificador, en caso de no encontrar la configuración retornará el segundo parametro, por default null 
suponiendo que existe la siguiente configuración:

| Configuración            | Identificador         | Valor |
|--------------------------|-----------------------|-------|
| color de asento          | COLOR_ASENTO          | BLUE  |
| tamaño maximo de archivo | TAMANO_MAXIMO_ARCHIVO | 2048  |
| tipo de archivo valido   | TIPO_ARCHIVO_VALIDO   | PDF   |

```php
dbconfig('COLOR_ASENTO') // BLUE
dbconfig('COLOR_SECUNDARIO') // null
dbconfig('COLOR_SECUNDARIO', 'gray') // 'gray'
```

## Testing

```bash
composer test
```

## Registro de cambios

Ver el [CHANGELOG](CHANGELOG.md) para más información de los cambios recientes.

## Vulnerabilidad de seguridad

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Creditos

- [Raciel Jonathan Marquez Mijangos](https://github.com/RaJoMaMi)
- [All Contributors](../../contributors)

## License

Licencia MIT(MIT). Ve el archivo de [Licencia](LICENSE.md) para mas información
