<?php

namespace ILC\ConfigCenter;

use ILC\ConfigCenter\Commands\Commands\ConfigCenterInstallCommand;
use ILC\ConfigCenter\Controllers\ConfiguracionController;
use ILC\ConfigCenter\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Route;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class ConfigCenterServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('configcenter')
            ->hasViews()
            ->hasAssets()
            ->hasCommand(ConfigCenterInstallCommand::class)
            ->hasMigration('create_configcenters_table')
            ->hasConfigFile('configcenter');
    }

    public function packageRegistered()
    {
        // Verificamos si el paquete de administración de usuarios está instalado, si está instlado entonces ilc.auth se
        // debe agregar
        $middlewares = array_merge(['api', 'web'], class_exists(\ILC\AdminUsuarios\AdminUsuariosServiceProvider::class) ? ['ilc.auth'] : []);

        //rutas del paquete
        Route::middleware('auth:sanctum')->group(function () use ($middlewares) {

            Route::prefix('api')->middleware($middlewares)->group(function () {

                Route::get('gestionar-configuraciones', [ConfiguracionController::class, 'renderFront'])
                    ->middleware(config('configcenter.seguridad_activa') ? 'can:ver-listado-configuracion' : null);

                if (config('configcenter.seguridad_activa')) {
                    Route::get('configuraciones', [ConfiguracionController::class, 'index'])->middleware('can:ver-listado-configuracion');
                    Route::post('configuraciones', [ConfiguracionController::class, 'store'])->middleware('can:crear-configuracion');
                    Route::get('configuraciones/{configuracion}', [ConfiguracionController::class, 'show'])->middleware('can:ver-listado-configuracion');
                    Route::put('configuraciones/{configuracion}', [ConfiguracionController::class, 'update'])->middleware('can:editar-configuracion');
                    Route::delete('configuraciones/{configuracion}', [ConfiguracionController::class, 'destroy'])->middleware('can:borrar-configuracion');
                } else {
                    Route::apiResource('configuraciones', ConfiguracionController::class);
                }

                Route::put('configuraciones/{configuracion}/valor', [ConfiguracionController::class, 'changeValue'])
                    ->middleware(config('configcenter.seguridad_activa') ? 'can:cambiar-valor-configuracion' : null);
            });

        });

    }

    public function bootingPackage()
    {
        //para helper global
        $file = __DIR__ . '/Helpers/ConfigCenterHelper.php';
        if (file_exists($file)) {
            require_once($file);
        }
        //para los eventos y listener
        $this->app->register(EventServiceProvider::class);
    }
}
