<?php

namespace ILC\ConfigCenter;

use ILC\ConfigCenter\Commands\Commands\ConfigCenterInstallCommand;
use ILC\ConfigCenter\Controllers\ConfiguracionController;
use ILC\ConfigCenter\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Route;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class ConfigCenterServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('configcenter')
            ->hasViews()
            ->hasAssets()
            ->hasCommand(ConfigCenterInstallCommand::class)
            ->hasMigration('create_configcenters_table')
            ->hasConfigFile('configcenter');
    }

    public function packageRegistered()
    {
        // Verificamos si el paquete de administración de usuarios está instalado, si está instlado entonces ilc.auth se
        // debe agregar
        $middlewares = array_merge(['api', 'web'], class_exists(\ILC\AdminUsuarios\AdminUsuariosServiceProvider::class) ? ['ilc.auth'] : []);

        //rutas del paquete
        Route::middleware('auth:sanctum')->group(function () use ($middlewares) {

            Route::prefix('api')->middleware($middlewares)->group(function () {

                Route::get('gestionar-configuraciones', [ConfiguracionController::class, 'renderFront'])
                    ->middleware(config('configcenter.seguridad_activa') ? 'can:ver-listado-configuracion' : null);

                Route::apiresource('configuraciones', ConfiguracionController::class)
                    ->parameters([
                            'configuraciones' => 'configuracion'
                        ])
                    ->middleware( config('configcenter.seguridad_activa') ?
                        [
                            'index' => 'can:ver-listado-configuracion',
                            'store' => 'can:crear-configuracion',
                            'show' => 'can:ver-listado-configuracion',
                            'update' => 'can:editar-configuracion',
                            'destroy' => 'can:borrar-configuracion',
                        ] : []
                    )->whereNumber('configuraciones');

                Route::put('configuraciones/{configuracion}/valor', [ConfiguracionController::class, 'changeValue'])
                    ->middleware(config('configcenter.seguridad_activa') ? 'can:cambiar-valor-configuracion' : null);
            });

        });

    }

    public function bootingPackage()
    {
        //para helper global
        $file = __DIR__ . '/Helpers/ConfigCenterHelper.php';
        if (file_exists($file)) {
            require_once($file);
        }
        //para los eventos y listener
        $this->app->register(EventServiceProvider::class);
    }
}
