<?php

namespace ILC\ConfigCenter\Commands\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\Console\Output\ConsoleOutput;

class ConfigCenterInstallCommand extends Command
{
    public $signature = 'configcenter:instalar {--F|includeFront : Si usas esta bandera se publicara la version del front compilada del paquete como un asset}';

    public $description = 'Comando de instalacion para configCenter';

    public function handle(): int
    {
        $directorioDeAssets = public_path('vendor'. DIRECTORY_SEPARATOR .'configcenter');
        $output = new ConsoleOutput();

        $this->comment('Instalando ConfigCenter');

        $output->write('<comment>Copiando migraciones ..... </comment>');
        Artisan::call('vendor:publish', ['--tag' => 'configcenter-migrations']);
        $output->write('<info>hecho!</info>');
        $output->writeln('');
        $output->write('<comment>Ejecutando migraciones ..... </comment>');
        Artisan::call('migrate');
        $output->write('<info>hecho!</info>');
        $output->writeln('');
        if( $this->comment($this->option('includeFront')) ){
            if( is_dir($directorioDeAssets) ) {
                $output->write('<comment>Eliminando assets anteriores ..... </comment>');
                $this->eliminarDirectorio($directorioDeAssets);
                $output->write('<info>hecho!</info>');
                $output->writeln('');
            }
            $output->write('<comment>Copiando assets ..... </comment>');
            Artisan::call('vendor:publish',['--tag' => 'configcenter-assets']);
            $output->write('<info>hecho!</info>');
            $output->writeln('');
        }
        if( config('configcenter.seguridad_activa') ){
            Artisan::call('db:seed', ['--class' => '\\ILC\\ConfigCenter\\Database\\Seeders\\ConfigCenterSeeder']);
        } else {
            $this->info('Omitiendo creación de permisos y roles');
        }
        $this->info('ConfigCenter se ha instalado correctamente');
        $this->newLine(1);
        $this->info('visita '.config('app.url').'/gestionar-configuraciones para comenzar');
        return self::SUCCESS;
    }

    private function eliminarDirectorio($dir)
    {
        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') continue;
            $itemPath = $dir . DIRECTORY_SEPARATOR . $item;
            if (is_dir($itemPath)) {
                $this->eliminarDirectorio($itemPath);
            } else {
                unlink($itemPath);
            }
        }
        rmdir($dir);
    }
}
