<?php

namespace ILC\ConfigCenter\Database\Seeders;

use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Illuminate\Database\Seeder;

class ConfigCenterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Role::firstOrCreate([
            'name' => 'Super usuario',
        ],
        [
            'name' => 'Super usuario',
        ]);

        $permisos = [
            [
                'name' => 'ver-listado-configuracion'
            ],
            [
                'name' => 'crear-configuracion'
            ],
            [
                'name' => 'editar-configuracion'
            ],
            [
                'name' => 'borrar-configuracion'
            ],
            [
                'name' => 'cambiar-valor-configuracion'
            ],
        ];

        foreach ($permisos as $permiso) {
            Permission::firstOrCreate(['name' => $permiso['name']], $permiso);
        }

    }
}
