<?php

namespace ILC\MenuCenter\Commands;

use ILC\MenuCenter\Database\Seeders\MenuCenterPermisosSeeder;
use Illuminate\Console\Command;

class InstallMenuCenterCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'menu_center:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Instala el paquete Menu Center';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->comment('Iniciando la instalación del paquete Menu Center...');

        $this->call('vendor:publish', [
            '--tag' => 'menu_center-config',
        ]);

        $this->call('vendor:publish', [
            '--tag' => 'menu_center-migrations',
        ]);

        // Ejecutar migraciones (opcional)
        if ($this->confirm('¿Deseas ejecutar las migraciones ahora?', true)) {
            $this->call('migrate');
        }

        if ($this->confirm('¿Deseas ejecutar el seeder predeterminado ahora?', true)) {
            $this->call('db:seed', [
                '--class' => MenuCenterPermisosSeeder::class,
            ]);
        }

        $this->info('¡Instalación completada!');
    }
}
