<?php

namespace ILC\MenuCenter\Database\Factories;

use ILC\MenuCenter\Models\Menu;
use Illuminate\Database\Eloquent\Factories\Factory;

class MenuFactory extends Factory
{
    protected $model = Menu::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->name,
            'route' => $this->faker->url,
            'order' => $this->faker->numberBetween(1, 10),
            'permission_name' => null,
            'layout' => 'top',
            'enabled' => $this->faker->boolean,
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
