<?php

use Illuminate\Support\Facades\Route;
use ILC\MenuCenter\Http\Controllers\MenuController;

Route::middleware(['auth:sanctum', 'ilc.auth', 'api', 'web'])->group(function () {
    // Menús
    Route::prefix('api/menus')->group(function () {
        Route::post('/', [MenuController::class, 'createMenuRoot'])->name('api.menus.store');
        Route::get('/{id}', [MenuController::class, 'getMenuRoot'])->name('api.menus.get');
        Route::put('/{id}', [MenuController::class, 'updateMenuRoot'])->name('api.menus.update');
        Route::delete('/{id}', [MenuController::class, 'deleteMenuRoot'])->name('api.menus.destroy');
    });
    Route::prefix('api/menu-items')->group(function () {
        Route::post('/', [MenuController::class, 'createMenuItem'])->name('api.menu-items.store');
        Route::put('/{id}', [MenuController::class, 'updateMenuItem'])->name('api.menu-items.update');
        Route::delete('/{id}', [MenuController::class, 'deleteMenuItem'])->name('api.menu-items.destroy');
    });

    Route::prefix('api/menu-views')->group(function () {
        Route::get('/root_tree', [MenuController::class, 'getMenuRootTree'])->name('api.menu-views.tree');
        Route::get('/tree/{menu_root}', [MenuController::class, 'getMenuTree'])->name('api.menu-items-views.tree');
        Route::get('/breadcrumbs/{id}', [MenuController::class, 'getBreadcrumbs'])->name('api.menu-views.breadcrumbs');
    });
});
