<?php

namespace ILC\MenuCenter\Database\Seeders;

use ILC\ConfigCenter\Events\ConfiguracionCreada;
use ILC\ConfigCenter\Models\Configuracion;
use ILC\MenuCenter\Models\Menu;
use ILC\MenuCenter\Models\MenuRoot;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class MenuCenterPermisosSeeder extends Seeder
{
    public function run(): void
    {
        if (!Permission::where('name', 'menu-center-listar-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-listar-menus',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-listar-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-listar-menus');
        }

        if (!Permission::where('name', 'menu-center-crear-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-crear-menus',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-crear-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-crear-menus');
        }

        if (!Permission::where('name', 'menu-center-editar-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-editar-menus',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-editar-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-editar-menus');
        }

        if (!Permission::where('name', 'menu-center-eliminar-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-eliminar-menus',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-eliminar-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-eliminar-menus');
        }

        $roleSuperUsuario = Role::firstOrCreate(['name' => 'Super usuario', 'guard_name' => 'web']);
        $roleSuperUsuario->syncPermissions([
            'menu-center-listar-menus',
            'menu-center-crear-menus',
            'menu-center-editar-menus',
            'menu-center-eliminar-menus',
        ]);

        $role = Role::firstOrCreate(['name' => 'administrador', 'guard_name' => 'web']);

        $role->syncPermissions([
            'menu-center-listar-menus',
            'menu-center-crear-menus',
            'menu-center-editar-menus',
            'menu-center-eliminar-menus',
        ]);

        $this->command->info('Agregando menu root');
        $menuRootId = DB::table('menu_root')->insertGetId([
            'name' => 'menu_lateral',
            'description' => 'left',
            'layout' => 'horizontal',
            'enabled' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $configKey = config('menu_center.menu_key', 'MENU_STARTER_KIT');

        $config = Configuracion::create([
            'nombre' => 'Menu StarterKit',
            'identificador' => $configKey,
            'descripcion' => 'Menu StarterKit',
            'tipo' => 'numeric-input',
            'opciones' => '{"type": "integer","title": "Valor*","layout": "text-field"}',
            'valor' => $menuRootId,
            'tags' => "menu,menu_starter_kit,menu_lateral",
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        ConfiguracionCreada::dispatch($config);

        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Módulo de Menu',
            'route' => null,
            'icon' => null,
            'order' => 9,
            'description' => 'Módulo de Menu',
            'separator' => true,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => null,
            'icon_name' => '',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Menu center',
            'route' => '/menu-center',
            'icon' => 'mdi-microsoft-xbox-controller-menu',
            'order' => 10,
            'description' => 'Menu center',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => null,
            'icon_name' => 'mdiMicrosoftXboxControllerMenu',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);


        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Administración',
            'route' => null,
            'icon' => null,
            'order' => 11,
            'description' => 'Administración',
            'separator' => true,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => null,
            'icon_name' => '',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Usuarios',
            'route' => '/admin/users',
            'icon' => 'mdi-account-multiple',
            'order' => 12,
            'description' => 'Usuarios',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => null,
            'icon_name' => 'mdiAccountMultiple',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        if (app()->environment('local')) {
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Menú',
                'route' => null,
                'icon' => null,
                'order' => 1,
                'description' => 'Menú',
                'separator' => true,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => '',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Inicio',
                'route' => '/',
                'icon' => 'mdi-home',
                'order' => 2,
                'description' => 'Inicio',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiHome',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Módulo de configuraciones',
                'route' => null,
                'icon' => null,
                'order' => 3,
                'description' => 'Módulo de configuraciones',
                'separator' => true,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => '',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Configuraciones',
                'route' => '/configuraciones',
                'icon' => 'mdi-wrench-cog-outline',
                'order' => 4,
                'description' => 'Configuraciones',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiWrenchCogOutline',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Modulo de permisos',
                'route' => null,
                'icon' => null,
                'order' => 5,
                'description' => 'Modulo de permisos',
                'separator' => true,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => '',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Permisos',
                'route' => '/permisos',
                'icon' => 'mdi-key-chain',
                'order' => 6,
                'description' => 'Permisos',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiKeyChain',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Roles',
                'route' => '/roles',
                'icon' => 'mdi-account-group-outline',
                'order' => 7,
                'description' => 'Roles',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountGroupOutline',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Asignar',
                'route' => '/usuarios/asignar',
                'icon' => 'mdi-account-lock',
                'order' => 8,
                'description' => 'Asignar',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountLock',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Prueba Menu',
                'route' => null,
                'icon' => null,
                'order' => 13,
                'description' => 'Prueba Menu',
                'separator' => true,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => '',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('menus')->insert([
                'parent_id' => null,
                'name' => 'Prueba Menu GrandParent',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 14,
                'description' => 'Prueba Menu GrandParent',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $grandParentMenu = DB::table('menus')->insertGetId([
                'parent_id' => null,
                'name' => 'Prueba Menu GrandParent with children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 15,
                'description' => 'Prueba Menu GrandParent with children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $parentMenu = DB::table('menus')->insertGetId([
                'parent_id' => $grandParentMenu,
                'name' => 'Prueba Menu Parent without children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 1,
                'description' => 'Prueba Menu GrandParent with children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $parentMenuWithChildren = DB::table('menus')->insertGetId([
                'parent_id' => $grandParentMenu,
                'name' => 'Prueba Menu Parent with children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 2,
                'description' => 'Prueba Menu Parent with children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $ChildrenMenuWithChildren = DB::table('menus')->insertGetId([
                'parent_id' => $parentMenuWithChildren,
                'name' => 'Prueba Menu children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 1,
                'description' => 'Prueba Menu children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            Menu::firstOrCreate([
                'parent_id' => null,
                'name' => 'Prueba Menu',
                'menu_root_id' => $menuRootId,
            ], [
                'parent_id' => null,
                'name' => 'Prueba Menu',
                'route' => null,
                'icon' => null,
                'order' => 13,
                'description' => 'Prueba Menu',
                'separator' => true,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => '',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            Menu::firstOrCreate([
                'parent_id' => null,
                'name' => 'Prueba Menu GrandParent',
                'menu_root_id' => $menuRootId,
            ], [
                'parent_id' => null,
                'name' => 'Prueba Menu GrandParent',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 14,
                'description' => 'Prueba Menu GrandParent',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $grandParentMenu = Menu::firstOrCreate([
                'parent_id' => null,
                'name' => 'Prueba Menu GrandParent with children',
                'menu_root_id' => $menuRootId,
            ], [
                'parent_id' => null,
                'name' => 'Prueba Menu GrandParent with children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 15,
                'description' => 'Prueba Menu GrandParent with children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $parentMenu = Menu::firstOrCreate([
                'parent_id' => $grandParentMenu->id,
                'name' => 'Prueba Menu Parent without children',
                'menu_root_id' => $menuRootId,
            ], [
                'parent_id' => $grandParentMenu->id,
                'name' => 'Prueba Menu Parent without children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 1,
                'description' => 'Prueba Menu GrandParent with children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $parentMenuWithChildren = Menu::firstOrCreate([
                'parent_id' => $grandParentMenu->id,
                'name' => 'Prueba Menu Parent with children',
                'menu_root_id' => $menuRootId,
            ], [
                'parent_id' => $grandParentMenu->id,
                'name' => 'Prueba Menu Parent with children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 2,
                'description' => 'Prueba Menu Parent with children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $ChildrenMenuWithChildren = Menu::firstOrCreate([
                'parent_id' => $parentMenuWithChildren->id,
                'name' => 'Prueba Menu children',
                'menu_root_id' => $menuRootId,
            ], [
                'parent_id' => $parentMenuWithChildren->id,
                'name' => 'Prueba Menu children',
                'route' => '/menu-center',
                'icon' => 'mdi-account-multiple',
                'order' => 1,
                'description' => 'Prueba Menu children',
                'separator' => false,
                'layout' => 'left',
                'enabled' => true,
                'permission_name' => null,
                'icon_name' => 'mdiAccountMultiple',
                'menu_root_id' => $menuRootId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

    }
}
