<?php

namespace ILC\MenuCenter\Models;

use ILC\MenuCenter\Database\Factories\MenuFactory;
use ILC\MenuCenter\Database\Factories\MenuRootFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Support\Facades\Cache;
use ILC\MenuCenter\Events\{
    MenuCreado, MenuModificado, MenuEliminado, MenuActivado, MenuDesactivado, MenuItemCreado,
    MenuItemModificado, MenuItemEliminado, MenuItemActivado, MenuItemDesactivado
};

class MenuRoot extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'menu_root';

    protected $fillable = [
        'name',
        'description',
        'enabled',
        'layout'
    ];
    protected $dispatchesEvents = [
        'MenuCreado' => MenuCreado::class,
        'MenuModificado' => MenuModificado::class,
        'MenuEliminado' => MenuEliminado::class,
        'MenuActivado' => MenuActivado::class,
        'MenuDesactivado' => MenuDesactivado::class,
    ];
    protected static function newFactory()
    {
        return MenuRootFactory::new();
    }
}
