<?php

declare(strict_types=1);

namespace ILC\MenuCenter;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use ILC\MenuCenter\Commands\InstallMenuCenterCommand;

class MenuCenterServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('menu_center')
            ->hasConfigFile(['menu_center'])
            ->hasRoute('api')
            ->hasMigrations(['01_create_menu_item_table', '02_update_menu_table', '03_update_menu_table_icon_name', '04_create_menu_root_table'])
            ->publishesServiceProvider(MenuCenterServiceProvider::class)
            ->hasCommand(InstallMenuCenterCommand::class);

        $this->publishes([
            __DIR__ . '/../database/seeders/MenuCenterPermisosSeeder.php' => database_path('seeders/MenuCenterPermisosSeeder.php'),
        ], 'menu_center-seeders');
    }
}
