<?php

namespace ILC\MenuCenter\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class MenuCenterPermisosSeeder extends Seeder
{
    public function run(): void
    {
        if (!Permission::where('name', 'menu-center-listar-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-listar-menus',
//                'description' => 'El usuario puede ver el listado de los menús y sus items (hijos) del sistema',
//                'module' => 'menu-center',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-listar-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-listar-menus');
        }

        if (!Permission::where('name', 'menu-center-crear-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-crear-menus',
//                'description' => 'El usuario puede ver el listado de los menús y sus items (hijos) del sistema',
//                'module' => 'menu-center',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-crear-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-crear-menus');
        }

        if (!Permission::where('name', 'menu-center-editar-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-editar-menus',
//                'description' => 'El usuario puede ver el listado de los menús y sus items (hijos) del sistema',
//                'module' => 'menu-center',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-editar-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-editar-menus');
        }

        if (!Permission::where('name', 'menu-center-eliminar-menus')->first()) {
            Permission::firstOrCreate([
                'name' => 'menu-center-eliminar-menus',
//                'description' => 'El usuario puede ver el listado de los menús y sus items (hijos) del sistema',
//                'module' => 'menu-center',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso menu-center-eliminar-menus');
        } else {
            $this->command->warn('Ya se encuentra permiso menu-center-eliminar-menus');
        }
    }
}
