<?php

namespace ILC\MenuCenter\Http\Middleware;

use Closure;
use ILC\MenuCenter\Models\MenuRoot;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AddMenuToLoginResponse
{
    /**
     * @param Closure(Request): (Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        if (
            $request->is('api/login') &&
            $request->isMethod('post') &&
            $response instanceof JsonResponse
        ) {
            $data = $response->getData(true);
            $menuId =  dbconfig('MENU_STARTER_KIT');
            $menu = MenuRoot::find($menuId);

            $data['result']['menu_root'] = [
                'id' => $menuId,
                'layout' => $menu->layout,
            ];

            $response->setData($data);
        }

        return $response;
    }
}
