<?php

namespace ILC\MensajeriaCenter\Models;

use ILC\MensajeriaCenter\Database\Factories\MensajeriaLogFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class MensajeriaLog extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'mensajeria_center_log';

    protected $fillable = ['users_id', 'mensajeria_id', 'is_read'];


    protected static function newFactory(): MensajeriaLogFactory
    {
        return MensajeriaLogFactory::new();
    }
    public function users()
    {
        return $this->belongsTo(config('mensajeria_center.user_model'), 'users_id', 'id');
    }

    public function mensajeria(): BelongsTo
    {
        return $this->belongsTo(MensajeriaCenter::class, 'mensajeria_id', 'id');
    }
}
