<?php

namespace ILC\MensajeriaCenter\Http\Controllers;

use ILC\MensajeriaCenter\Models\CatalogoTipoNotificaciones;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CatalogoTipoNotificacionesController
{
    /**
     * Get all notification types
     *
     * @return JsonResponse
     */
    public function getListTiposNotificacion(): JsonResponse
    {
        $result =  CatalogoTipoNotificaciones::all('id', 'nombre', 'icono', 'color');
        return response()->json($result);

    }

    /**
     * Create a new notification type
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function createTipoNotificacion(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'nombre' => 'required|string|max:255',
            'icono' => 'nullable|string|max:255',
            'color' => 'nullable|string|max:255',
        ]);

        $tipoNotificacion = CatalogoTipoNotificaciones::createTipo($validated);
        return response()->json($tipoNotificacion, 201);
    }

    /**
     * Get notification type by ID
     *
     * @param int $id
     * @return JsonResponse
     */
    public function getTipoNotificacion(int $id): JsonResponse
    {
        $tipoNotificacion = CatalogoTipoNotificaciones::findTipo($id);

        if (!$tipoNotificacion) {
            return response()->json(['message' => 'Tipo de comunicación no encontrada'], 404);
        }

        return response()->json($tipoNotificacion);
    }
}
