<?php

namespace ILC\NotificacionCenter;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use ILC\NotificacionCenter\Commands\InstallNotificacionCenterCommand;

class NotificacionCenterServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('notificacion_center')
            ->hasConfigFile(['notificacion_center'])
            ->hasMigration('01_create_notificacion_center_table')
            ->publishesServiceProvider(NotificacionCenterServiceProvider::class)
            ->hasCommand(InstallNotificacionCenterCommand::class);
    }
}
