<?php

namespace ILC\NotificacionCenter\Models;

use ILC\NotificacionCenter\Database\Factories\NotificacionCenterModelFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Model;

class NotificacionCenterModel extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $fillable = [
        'creador_id',
        'contenido',
        'medio',
        'subject',
        'users_id',
        'filter_applied'
    ];

    protected $casts = [
        'users_id' => 'array',
        'filter_applied' => 'array',
    ];

    protected static function newFactory(): NotificacionCenterModelFactory
    {
        return NotificacionCenterModelFactory::new();
    }
}
