<?php

declare(strict_types=1);

namespace ILC\NotificacionCenter\Http\Controllers;

use ILC\NotificacionCenter\Http\Requests\NotificacionRequest;
use ILC\NotificacionCenter\Models\NotificacionCenterModel;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Response;
use Illuminate\Routing\Controllers\Middleware;

class NotificacionCenterController
{
    public static function middleware(): array
    {
        return [
            new Middleware(['auth:sanctum','can:notificacion-center-listar'], only: ['getListNotificacion', 'getNotificacionScope', 'getNotificacion']),
            new Middleware(['auth:sanctum','can:notificacion-center-crear'], only: ['createNotificacion']),
            new Middleware(['auth:sanctum','can:notificacion-center-editar'], only: ['updateNotificacion']),
            new Middleware(['auth:sanctum','can:notificacion-center-eliminar'], only: ['deleteNotificacion'])
        ];
    }
    public function getListNotificacion()
    {
        $notificacionCenterModel = NotificacionCenterModel::all();

        return response()->json($notificacionCenterModel);
    }

    public function createNotificacion(NotificacionRequest $request): JsonResponse
    {
        $notificacionRequest = NotificacionCenterModel::create($request->all());

        return response()->json($notificacionRequest);
    }

    public function getNotificacion(NotificacionRequest $request, $id): JsonResponse
    {
        $notificacion = NotificacionCenterModel::findOrFail($id);

        return response()->json($notificacion);
    }
    public function updateNotificacion(NotificacionRequest $request, $id): JsonResponse
    {
        $notificacion = NotificacionCenterModel::findOrFail($id);
        $notificacion->update($request->all());

        return response()->json($notificacion);
    }

    public function deleteNotificacion(NotificacionRequest $request, $id): Response
    {
        $notificacion = NotificacionCenterModel::findOrFail($id);
        $notificacion->delete();

        return response()->noContent();
    }
    public function getNotificacionScope(): JsonResponse
    {

        return response()->json([]);
    }
}
