<?php

namespace ILC\NotificacionCenter\Commands;

use ILC\MenuCenter\Database\Seeders\MenuCenterPermisosSeeder;
use ILC\NotificacionCenter\Database\Seeders\NotificacionCenterPermisosSeeder;
use Illuminate\Console\Command;

class InstallNotificacionCenterCommand extends Command
{
    public $signature = 'notificacion_center:install';

    public $description = 'Notificacion Center instalación';

    public function handle(): int
    {
        $this->comment('Iniciando la instalación del paquete Notificacion Center...');

        $this->call('vendor:publish', [
            '--tag' => 'notificacion_center-config',
        ]);

        $this->call('vendor:publish', [
            '--tag' => 'notificacion_center-migrations',
        ]);

        if ($this->confirm('¿Deseas ejecutar las migraciones ahora?', false)) {
            $this->call('migrate');
        }

        if ($this->confirm('¿Deseas ejecutar el seeder predeterminado ahora?', false)) {
            $this->call('db:seed', [
                '--class' => NotificacionCenterPermisosSeeder::class,
            ]);
        }

        $this->info('¡Instalación completada!');

        return self::SUCCESS;
    }
}
