<?php

use ILC\NotificacionCenter\Http\Controllers\NotificacionCenterController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth:sanctum', 'ilc.auth', 'api', 'web'])->group(function () {
    // Notificacion
    Route::prefix('api/notificacion_center')->group(function () {
        Route::get("/", [NotificacionCenterController::class, 'getListNotificacion'])->name('api.notificacion_center.index');
        Route::post('/', [NotificacionCenterController::class, 'createNotificacion'])->name('api.notificacion_center.store');
        Route::get('/{id}', [NotificacionCenterController::class, 'getNotificacion'])->name('api.notificacion_center.get');
        Route::put('/{id}', [NotificacionCenterController::class, 'updateNotificacion'])->name('api.notificacion_center.update');
        Route::delete('/{id}', [NotificacionCenterController::class, 'deleteNotificacion'])->name('api.notificacion_center.destroy');
    });
    Route::prefix('api/notificacion_center/scope')->group(function () {
        Route::get('/', [NotificacionCenterController::class, 'getNotificacionScope'])->name('api.notificacion_center.scope');
    });
});
