<?php

namespace ILC\MensajeriaCenter\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use ILC\MensajeriaCenter\Database\Factories\CatalogoTipoNotificacionesFactory;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;


class CatalogoTipoNotificaciones extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'catalogo_tipo_notificaciones';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nombre',
        'icono',
        'color',
    ];


    /**
     * Find a notification type by ID
     *
     * @param int $id
     * @return self|null
     */
    public static function findTipo(int $id): ?self
    {
        return self::find($id);
    }
}
