<?php

namespace ILC\MensajeriaCenter;

use Event;
use ILC\MensajeriaCenter\Jobs\SendScheduledNotifications;
use Illuminate\Console\Scheduling\Schedule;
use ILC\MensajeriaCenter\Console\Kernel;
use ILC\MensajeriaCenter\Events\RoleAssigned;
use ILC\MensajeriaCenter\Listeners\AssignNotificationsOnRole;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use ILC\MensajeriaCenter\Commands\InstallMensajeriaCenterCommand;

class MensajeriaCenterServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('mensajeria_center')
            ->hasConfigFile(['mensajeria_center'])
            ->hasRoute('api')
            ->hasMigrations(['01_creacion_mensajeria_center_table',
                '02_creacion_mensajeria_center_log_table',
                '03_create_catalogo_tipo_notificaciones_table',
                '04_update_mensajeria_center_table'
                ])
            ->publishesServiceProvider(MensajeriaCenterServiceProvider::class)
            ->hasCommand(InstallMensajeriaCenterCommand::class);
    }



    public function packageBooted()
    {
        $this->app->booted(function () {
            $schedule = $this->app->make(Schedule::class);
            $schedule->job(new SendScheduledNotifications())->everyMinute();
        });
    }
}
