<?php

use ILC\MensajeriaCenter\Http\Controllers\MensajeriaCenterController;
use ILC\MensajeriaCenter\Http\Controllers\CatalogoTipoNotificacionesController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth:sanctum', 'ilc.auth', 'api', 'web'])->group(function () {
    Route::prefix('api/mensajeria_center')->group(function () {
        Route::get("/", [MensajeriaCenterController::class, 'getListMensajeria'])->name('api.mensajeria_center.index');
        Route::post('/', [MensajeriaCenterController::class, 'createMensajeria'])->name('api.mensajeria_center.store');
        Route::get('/scope', [MensajeriaCenterController::class, 'getMensajeriaScope'])->name('api.mensajeria_center.scope');
        Route::get('/{id}', [MensajeriaCenterController::class, 'getMensajeria'])->name('api.mensajeria_center.get');
        Route::post('/{id}', [MensajeriaCenterController::class, 'updateMensajeria'])->name('api.mensajeria_center.update');
        Route::delete('/{id}', [MensajeriaCenterController::class, 'deleteMensajeria'])->name('api.mensajeria_center.destroy');
        Route::post('/notifications/{id}/read', [MensajeriaCenterController::class, 'marcarComoLeido'])->name('api.mensajeria_center.marcarComoLeido');
        Route::get('/{id}/views', [MensajeriaCenterController::class, 'getUsersWhoReadMessage'])->name('api.mensajeria_center.views');
        Route::get('attachment/{id}/{name}', [MensajeriaCenterController::class, 'downloadAttachment'])->name('api.mensajeria_center.attachment');
        Route::get('/notifications/user', [MensajeriaCenterController::class, 'getMensajeriaNotifications'])->name('api.mensajeria_center.notifications');
        Route::post('/{id}/status', [MensajeriaCenterController::class, 'updateMessageStatus'])->name('api.mensajeria_center.status');
        Route::get('/detailtouser/{id}', [MensajeriaCenterController::class, 'getMessageDetailToUser'])->name('api.mensajeria_center.detailtouser');
    });
    Route::get('api/tipos_notificaciones/', [CatalogoTipoNotificacionesController::class, 'getListTiposNotificacion'])->name('api.catalogo_tipo_notificaciones.index');
});
