<?php

namespace ILC\MensajeriaCenter\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CatalogoTipoNotificacionesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('Verificando tipos de comunicación predeterminados');

        $tiposNotificaciones = [
            ['nombre' => 'Recordatorio', 'icono' => 'mdi-bell-ring-outline', 'color' => 'warning'],
            ['nombre' => 'Nuevo mensaje', 'icono' => 'mdi-email-outline', 'color' => 'success'],
            ['nombre' => 'Alerta', 'icono' => 'mdi-alert-outline', 'color' => 'error']
        ];

        foreach ($tiposNotificaciones as $tipo) {
            if (DB::table('catalogo_tipo_notificaciones')->where('nombre', $tipo['nombre'])->first()) {
                $this->command->info("El tipo de comunicación '{$tipo['nombre']}' ya existe");
            } else {
                DB::table('catalogo_tipo_notificaciones')->insert([
                    'nombre' => $tipo['nombre'],
                    'icono' => $tipo['icono'],
                    'color' => $tipo['color'],
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
                $this->command->info("Agregando tipo de comunicación '{$tipo['nombre']}'");
            }
        }
    }
}
