<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('mensajeria_center', function (Blueprint $table) {
            $table->unsignedBigInteger('tipo_notificacion')->nullable()->change();
            $table->foreign('tipo_notificacion', 'mensajeria_center_catalogo_tipo_notificaciones_id_fk')
                ->references('id')
                ->on('catalogo_tipo_notificaciones')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mensajeria_center', function (Blueprint $table) {
            $table->dropForeign('mensajeria_center_catalogo_tipo_notificaciones_id_fk');
            $table->integer('tipo_notificacion')->nullable()->change();
            $table->string('icono', 255)->nullable()->default(null);
            $table->string('color', 255)->nullable()->default(null);
        });
    }
};
