<?php

namespace ILC\MensajeriaCenter\Database\Factories;

use ILC\MensajeriaCenter\Models\MensajeriaCenter;
use Illuminate\Database\Eloquent\Factories\Factory;

class MensajeriaCenterFactory extends Factory
{
    protected $model = MensajeriaCenter::class;

    public function definition(): array
    {
        return [
            'creador_id' => 1,
            'titulo' => $this->faker->title,
            'descripcion_corta' => $this->faker->text,
            'contenido' => $this->faker->text,
            'medio' => ['whatsapp', 'streaming'],
            'roles' => [],
            'blacklist' => [],
            'whitelist' => [],
            'filtros_aplicados' => [] ,
            'enviar_desde' => '',
            'terminar_hasta' => '',
            'esta_activo' => 1,
            'posibilidad_shortcut' => false,
            'tipo_notificacion' => 1,
            'attachment' => $this->faker->text
        ];
    }
}
