<?php

namespace ILC\MensajeriaCenter\Jobs;

use Carbon\Carbon;
use Clockwork\Request\Log;
use ILC\MensajeriaCenter\Models\MensajeriaCenter;
use ILC\MensajeriaCenter\Models\MensajeriaLog;
use ILC\MensajeriaCenter\Notifications\MensajeriaNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendScheduledNotifications implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function handle()
    {
        $notificaciones = MensajeriaCenter::where('esta_activo', true)
            ->where(function($query) {
                $query->where('permanent_visible', true)
                    ->orWhere(function($q) {
                        $q->where('enviar_desde', '<=', Carbon::now())
                            ->where('terminar_hasta', '>=', Carbon::now());
                    });
            })
            ->get();
        \Log::info('Notificaciones activas: ', $notificaciones->toArray());

        foreach ($notificaciones as $notificacion) {
            $usuariosYaNotificados = MensajeriaLog::where('mensajeria_id', $notificacion->id)
                ->pluck('users_id')
                ->toArray();
            \Log::info('Usuarios ya notificados: ', $usuariosYaNotificados);

        if ($notificacion->send_all) {
            $users = config('mensajeria_center.user_model')::whereNotIn('id', $usuariosYaNotificados)->get();
        } else {
            $users = config('mensajeria_center.user_model')::where(function ($query) use ($notificacion, $usuariosYaNotificados) {
                $query->whereHas('roles', function ($q) use ($notificacion) {
                    $q->whereIn('name', $notificacion->roles);
                })
                    ->whereNotIn('id', $usuariosYaNotificados) // Excluir notificados
                    ->whereNotIn('id', $notificacion->blacklist ?? []); // Excluir blacklist
            })
                ->orWhere(function ($query) use ($notificacion, $usuariosYaNotificados) {
                    $query->whereIn('id', $notificacion->whitelist ?? [])
                        ->whereNotIn('id', $usuariosYaNotificados); // Asegurar exclusión de ya notificados
                })
                ->get();
        }

        foreach ($users as $user) {
            \Log::info("Notificando al usuario ID: {$user->id}");

                $user->notify(new MensajeriaNotification($notificacion));

                MensajeriaLog::updateOrCreate([
                    'users_id' => $user->id,
                    'mensajeria_id' => $notificacion->id,
                ], [
                    'is_read' => false,
                ]);
            }
        }
    }
}
