<?php

namespace ILC\MensajeriaCenter\Database\Seeders;

use ILC\MensajeriaCenter\Models\MensajeriaCenter;
use ILC\MenuCenter\Models\Menu;
use ILC\MenuCenter\Models\MenuRoot;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;

class MensajeriaCenterPermisosSeeder extends Seeder
{
    public function run(): void
    {
        # Permisos de MensajeriaCenter
        if (!Permission::where('name', 'mensajeria-center-listar')->first()) {
            Permission::firstOrCreate([
                'name' => 'mensajeria-center-listar',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso mensajeria-center-listar');
        }else {
            $this->command->info('Ya existe permiso mensajeria-center-listar');
        }

        if (!Permission::where('name', 'mensajeria-center-crear')->first()) {
            Permission::firstOrCreate([
                'name' => 'mensajeria-center-crear',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso mensajeria-center-crear');
        }else {
            $this->command->info('Ya existe permiso mensajeria-center-crear');
        }

        if (!Permission::where('name', 'mensajeria-center-editar')->first()) {
            Permission::firstOrCreate([
                'name' => 'mensajeria-center-editar',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso mensajeria-center-editar');
        }else {
            $this->command->info('Ya existe permiso mensajeria-center-editar');
        }

        if (!Permission::where('name', 'mensajeria-center-eliminar')->first()) {
            Permission::firstOrCreate([
                'name' => 'mensajeria-center-eliminar',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso mensajeria-center-eliminar');
        }else {
            $this->command->info('Ya existe permiso mensajeria-center-eliminar');
        }

        if (!Permission::where('name', 'mensajeria-center-notificacion-user')->first()) {
            Permission::firstOrCreate([
                'name' => 'mensajeria-center-notificacion-user',
                'guard_name' => 'web'
            ]);
            $this->command->info('Agregando permiso mensajeria-center-notificacion-user');
        }else {
            $this->command->info('Ya existe permiso mensajeria-center-notificacion-user');
        }

        #Vamos a obtener el valor de menu_lateral
        $menu = MenuRoot::where('name', 'menu_lateral')->first();
        if (!$menu) {
            $this->command->info('No existe menu_lateral');
            return;
        }
        $menuRootId = $menu->id;

        $this->command->info('Agregando menú de Módulo de Comunicación');
        Menu::firstOrCreate(
            [
                'parent_id' => null,
                'name' => 'Módulo de Comunicación',
                'menu_root_id' => $menuRootId
            ],[
            'parent_id' => null,
            'name' => 'Módulo de Comunicación',
            'route' => null,
            'icon' => null,
            'order' => 15,
            'description' => 'Módulo de Comunicación',
            'separator' => true,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => null,
            'icon_name' => '',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now()
        ]);

        $this->command->info('Agregando item de mensajeria-center');
        Menu::firstOrCreate(
            [
              'parent_id' => null,
                'name' => 'Comunicación center',
                'menu_root_id' => $menuRootId
            ],[
            'parent_id' => null,
            'name' => 'Comunicación center',
            'route' => '/mensajeria-center',
            'icon' => 'mdi-microsoft-xbox-controller-menu',
            'order' => 16,
            'description' => 'Menú de Comunicación',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => null,
            'icon_name' => 'mdiMicrosoftXboxControllerMenu',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }
}
