<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('mensajeria_center_log', function (Blueprint $table) {
            $table->id();
            $table->boolean('is_read')
                ->default(false);

            #Creando la relación con la tabla mensajeria_center
            $table->foreignId('mensajeria_id')
                ->constrained('mensajeria_center')->cascadeOnDelete();

            $table->foreignId('users_id')
                ->constrained('users')
                ->onDelete('cascade');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('mensajeria_center_log');
    }
};
