<?php

namespace ILC\MensajeriaCenter\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class CatalogoTipoNotificacionesFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $icons = [
            'mdi-email-outline',
            'mdi-clock-outline',
            'mdi-bell-ring-outline',
            'mdi-alert-circle-outline',
            'mdi-bullhorn-outline',
            'mdi-chat-outline',
            'mdi-currency-usd'
        ];

        $colors = [
            'primary',
            'info',
            'blue',
            'error',
            'warning',
            'purple',
            'success'
        ];

        return [
            'nombre' => $this->faker->unique()->word(),
            'icono' => $this->faker->randomElement($icons),
            'color' => $this->faker->randomElement($colors),
        ];
    }
}
